<?php
/*******************************
 * Ajax: Product add to Enquity List
 *******************************/

add_action( 'wp_footer', 'add_btn_click_event_ajax' );

function add_btn_click_event_ajax() {
?>
<script type="text/javascript" >
jQuery(document).ready(function($) {

	$("body").on("click","a.continue-btn",function(event){
	 	event.preventDefault();
		$(this).parent("p.enq-response").fadeOut('slow');
	});

	$("body").on("click",".product-enquiry-click.click-link-btn", function(event){

		event.preventDefault();

		var currentClickedBtn = $(this);

		currentClickedBtn.after('<div class="gts-processing"></div>');

		var prodcutTitle = $(this).attr("data-title");
		var prodcutID = $(this).attr("data-id");
		var data = {
			'action': 'enqbtn_click_action',
			'clicked_product': prodcutTitle,
			'clicked_product_id': prodcutID
		};

		var ajaxurl = "<?php echo admin_url('admin-ajax.php'); ?>";

		$.post(ajaxurl, data, function(response) {
			
			var obj = jQuery.parseJSON( response );

			//If Response is Positive: 1
			if( obj.result === 1 ){
				if( obj.alert_type === 'inline'){
					
					currentClickedBtn.addClass('added');

					var currentProductClass = 'product-btn-' + obj.product_id;
					var msgToDisplay = '<strong>\"' + obj.product + ' (' + obj.product_id + ')\"</strong> added to quotation request form.';
					var continueButton = '<a href="#" class="continue-btn">'+obj.continue_text+'</a>';
					var formButton = '<a href="'+obj.btn_url+'" class="form-btn">'+obj.btn_text+'</a>';

					var formattedMag = continueButton +'<br>'+ formButton;

					$('body .gts-processing').remove();
	;
					$( "."+currentProductClass+"" ).after( "<p class='enq-response'>"+formattedMag+"</p>" );

					$('.enq-cart-block').html(obj.output);
				}
				else{

					$('.enq-cart-block').html(obj.output);

					$('body .gts-processing').remove();

					alert('"' + obj.product + ' (' + obj.product_id + ')" added to quotation request form.');
				}
			}
			if( obj.result === 0 ){
				alert('Opps! Something wrong happened!');
			}
			//If Items Already Exists In List: 3
			if( obj.result === 3 ){
				if( obj.alert_type === 'inline'){
					var currentProductClass = 'product-btn-' + obj.product_id;
					var msgToDisplay = 'This item already exists in your list.';
					var continueButton = '<a href="#" class="continue-btn">'+obj.continue_text+'</a>';
					var formattedMag = msgToDisplay +'<br>'+ continueButton +'<br>'+ formButton;

					$('body .gts-processing').remove();

					$( "."+currentProductClass+"" ).after( "<p class='enq-response'>"+msgToDisplay+"</p>" );
					$("."+currentProductClass+"").siblings('.enq-response').delay(3000).fadeOut();
				}
				else{
					
					$('body .gts-processing').remove();

					alert('This item already exists in your list.');
				}
			}		
		});
	});

});
</script>
<?php
}


/*******************************
 * Ajax Hanler: PHP Side
 *******************************/
add_action( 'wp_ajax_enqbtn_click_action', 'enqbtn_click_action' );
add_action( 'wp_ajax_nopriv_enqbtn_click_action', 'enqbtn_click_action' );

function enqbtn_click_action() {

    //Grabbing Post Data
    $product = $_POST["clicked_product"];
    $product_id = $_POST["clicked_product_id"];

    //Storing data in session
    $flag = 0;

    $porduct_pattern = $product;
    $id_pattern = $product_id;

    $addItemName = false;

    if( !isset($_SESSION["products_ids"]) ){
    	$_SESSION["products_ids"] = $id_pattern;
    	$addItemName = true;
    }
    else{
    	if (substr_count( $_SESSION["products_ids"], "$id_pattern") == 0) {
	    	$_SESSION["products_ids"] .= "-;-".$id_pattern;
	    	$addItemName = true;
	    }
	    else{
	    	$flag = 1;
	    }
    }
    
    //Exploding and Counting Session Products
    $total_items = explode("-;-", $_SESSION["products_ids"]);
	$total_items_count = count($total_items);

    //Get Alert Optons
    $gtsWooCatData = get_option('woocat_opt');

    $btnUrl 		= "";
    $btnLabel 		= __("Quote Me Now","gts");
    $continueLabel 	= __("Keep Browsing","gts");
    $popupType 		= 'inline';
    $clrBtnLabel	= __('Clear List', 'gts');
    
    if( isset( $gtsWooCatData['enq_page_url'] ) ){
    	$btnUrl 	= $gtsWooCatData['enq_page_url'];
    }
    if( isset( $gtsWooCatData['popup_type'] ) ){
    	$popupType 	= $gtsWooCatData['popup_type'];
    }
    if( isset( $gtsWooCatData['enq_btn_label'] ) ){
    	$btnLabel 	= $gtsWooCatData['enq_btn_label'];
    }
    if( isset( $gtsWooCatData['enq_continue_label'] ) ){
    	$continueLabel 	= $gtsWooCatData['enq_continue_label'];
    }

    $data = array();

    $data['alert_type'] = 'inline';
    $data['product_id'] = $product_id;

    if( $popupType == "inline" ){
    	$data['alert_type'] 	= 'inline';
    	$data['btn_text'] 		= $btnLabel;
    	$data['btn_url'] 		= $btnUrl;
	    $data['continue_text'] 	= $continueLabel;
    }
    else{
    	$data['alert_type'] 	= 'alert';
    	$data['btn_text'] 		= $btnLabel;
    	$data['btn_url'] 		= $btnUrl;
	    $data['continue_text'] 	= $continueLabel;
    }

    //Checking session and setting response
    if ($flag != 1) {

    	if( $_SESSION["products_ids"] != "" ){
	    	$data['product'] = $product;
	    	$data['result'] = 1;
	    	$data['product_count'] = $total_items_count;

	    	$output = "";

	    	$ids = explode("-;-", $_SESSION["products_ids"]);

			$output .= '<ul class="cart_list product_list_widget">';
					
			//asort($ids);

			$count = 0;

			foreach( $ids as $id) :

				if( $id != "" || $id != NULL ) :
					$output .= '<li>
						<a href="#" data-id="'.$id.'" class="remove enq-item-remove" title="Remove this item">
							x
						</a>
						<a href="'.get_the_permalink( $id ).'">'.
						get_the_post_thumbnail( $id, 'shop_catalog' ).get_the_title( $id ).'
						</a>
					</li>';

					$count++;
				endif;

			endforeach;

			$output .= '</ul>
			<p class="total">
				<strong>'.__("Total Item(s)", "gts").' :</strong> 
				<span class="amount">'.$count.'</span>
			</p>
			<p class="buttons">
				<a class="button wc-forward gts-enq-page-link" href="'.$btnUrl.'">'.$btnLabel.'</a>
				<a class="button wc-forward gts-clear-list" href="#">'.$clrBtnLabel.'</a>
			</p>';

			$data['output'] = $output;
	    }
	    else{
	    	$data['result'] = 0;
	    }
    }
    else{
    	$data['result'] = 3;
    }

    //json response
    echo json_encode($data);

	die();
}