<?php
/*******************************
 * Defining Ajax URL
 *******************************/

add_action('wp_head','gts_product_enq_ajaxurl');

function gts_product_enq_ajaxurl() {
	?>
	<script type="text/javascript">
	var ajaxurl = '<?php echo admin_url('admin-ajax.php'); ?>';
	</script>
	<?php
}


/*******************************
 * Custom Enquiry Form : Basic
 *******************************/

add_shortcode('enqform', 'basic_product_enquiry_form');

function basic_product_enquiry_form( $atts ){
	ob_start();
    basic_product_enquiry_form_output( $atts );
    $content = ob_get_clean();
    return $content;
}

function basic_product_enquiry_form_output( $atts = array() ) {
    //Options
	$data = extract( shortcode_atts( array(
		'name'  		=> '1',
		'email' 		=> '1',
		'subject' 		=> '1',
		'captcha' 		=> '1',
		'message' 		=> '1',
		'to_email' 		=> '',
		'name_label' 	=> __('Name','gts'),
		'email_label' 	=> __('Email','gts'),
		'subject_label' => __('Subject','gts'),
		'products_label'=> __('Products','gts'),
		'message_label' => __('Messge','gts'),
		'submit_label'  => __('Submit','gts'),
		'no_product_text'  => __('Your product selection list is empty.','gts'),
	), $atts ) );

	?>

	<!-- Form CSS -->
	<link rel="stylesheet" href="<?php echo WOO_ENQ_URL; ?>/assets/css/form-style.css">
	<!-- Form JS -->
	<script src="<?php echo WOO_ENQ_URL; ?>/assets/js/form-js.js"></script>

	<!-- Main Form: Basic Version -->
	<form action="" class="basic-enq-form">
		<div class="form-group">
			<label for="input-name"><?php echo $name_label; ?></label>
			<input type="text" name="input-name" id="input-name" class="gts-basic-input gts-basic-input-text">
		</div>
		<div class="form-group">
			<label for="input-email"><?php echo $email_label; ?></label>
			<input type="email" name="input-email" id="input-email" class="gts-basic-input gts-basic-input-text">
		</div>
		<div class="form-group">
			<label for="input-subject"><?php echo $subject_label; ?></label>
			<input type="text" name="input-subject" id="input-subject" class="gts-basic-input gts-basic-input-text">
		</div>
		<div class="form-group">
			<label for="input-porducts"><?php echo $products_label; ?></label>			
			<?php
			//Checking products, exploding and then adding as option
			$options = "";
			if( isset($_SESSION['products_ids']) && $_SESSION['products_ids'] != "" ){
			
		       $output = "";

		    	$ids = explode("-;-", $_SESSION["products_ids"]);

				$output .= '<div class="woocommerce"><ul class="cart_list_form product_list_widget">';
						
				//asort($ids);

				$count = 0;

				foreach( $ids as $id) :
				
					if( $id != "" || $id != NULL ) :

						$serialNo = $count+1;

						$options .= "<option selected>".$serialNo.")".get_the_title( $id )."(ID-".$id.")"."</option>";

						$output .= '<li>
							<a href="#" data-id="'.$id.'" class="remove enq-item-remove" title="Remove this item">
								x
							</a>
							<a href="'.get_the_permalink( $id ).'">'.
							get_the_post_thumbnail( $id, 'shop_catalog' ).get_the_title( $id ).'
							</a>
						</li>';

						$count++;

					endif;

				endforeach;

				$output .= '</ul>
				<p class="total">
					<strong>'.__("Total Item(s)", "gts").' :</strong> 
					<span class="amount">'.$count.'</span>
				</p>

				</div>';

				$html = $output;
				
				$html2 = '<select name="input-porducts[]" id="input-porducts" multiple class="gts-basic-input gts-basic-input-select" data-placeholder="Choose Item(s)">
		            '.$options.'
		          </select>';
			}
			else{
				$html = '<p class="no-product-text">' . $no_product_text . '</p>';
				$html2 = "";
			}

			?>

			<?php echo $html; ?>
			
			<?php echo $html2; ?>
			
		</div>
		<div class="form-group">
			<label for="input-message"><?php echo $message_label; ?></label>
			<textarea name="input-message" id="input-message" class="gts-basic-input gts-basic-input-textarea"></textarea>
		</div>
		<input type="hidden" name="input-toemail" id="input-toemail" value="<?php echo $to_email; ?>">
		<div class="form-group">
			<button name="input-submit" id="input-submit" class="gts-basic-input gts-basic-input-submit">
				<?php echo $submit_label; ?>
			</button>
		</div>
		<div class="gts-form-status"></div>
	</form>
	<?php
}


/*******************************
 * Ajax Hanler: Form Submission 
 *******************************/
add_action( 'wp_ajax_enq_form_action', 'enq_form_sumission_handler' );
add_action( 'wp_ajax_nopriv_enq_form_action', 'enq_form_sumission_handler' );

function enq_form_sumission_handler() {

    //Grabbing Post Data
    $postedName 	= $_POST["post_name"];
    $postedEmail 	= $_POST["post_email"];
    $postedSubject 	= $_POST["post_subject"];
    $postedProducts = $_POST["post_products"];
    $postedMessage 	= $_POST["post_message"];
    $postedToMail 	= $_POST["post_toemail"];
	
	$commaListProducts = implode(', ', $postedProducts);

    //Preparing Email
    $toAddress = ($postedToMail != "") ? $postedToMail : get_option('admin_email');

    $message = "
		<strong>Name:</strong> <br/>
		$postedName <br/><br/>

		<strong>Email:</strong> <br/>
		$postedEmail <br/><br/>

		<strong>Items:</strong> <br/>
		$commaListProducts <br/><br/>

		<strong>Message:</strong> <br/>
		$postedMessage
    ";

    //$headers = "From: $postedName <$postedEmail>" . "\r\n";
    "From: $postedEmail" . "\r\n" .
	"CC: ";
    
    //Sending Email
    add_filter( 'wp_mail_content_type', 'wpqre_set_html_content_type' );

    $mailSendResult = wp_mail(
    					$toAddress, 
    					$postedSubject, 
    					$message, 
    					$headers
    				  );
    				  

    remove_filter( 'wp_mail_content_type', 'wpqre_set_html_content_type' );

    //Setting Response
    $data = array();
    if ( $mailSendResult ) {

    	$data['result'] = 1;
    	$data['result_msg'] = __('Email was sent successfully. Thanks.', 'gts');

    }
    else{

    	$data['result'] = 2;
		$data['result_msg'] = __('Error in processing your request. Please try again.', 'gts');

    }

    //json response
    echo json_encode($data);

	die();
}

function wpqre_set_html_content_type() {
	return 'text/html';
}
