<?php
/*
Plugin Name: WooCommerce - Quote Request or Enquiry
Plugin URI: http://www.kadir.tech
Description: This plugin allows to switch off shopping functionality and visitors can add products to their enquiry or quote list to send their query to site administrator.
Version: 2.7
Author: Global Trend Soft (GTS).
Author URI: http://www.kadir.tech
Text Domain: gts
License: Single Site License

Copyright Notice: Full copyright of this plugin belongs to author of this plugin or as per envato license policy. This plugin is shipped for use only in a single site. If you want to use it in your multiple project or site, then please purchase an extended license from envato.

This product is tested with upto the following version of WordPress and WooCommerce - 
Tested WordPress Version: 5.2.2
Tested WooCommerce Version: 3.6.5

Update Date: 28/07/2019
*/

//Adding some variables
define('WOO_ENQ_DIR', plugin_dir_path(__FILE__) );
define('WOO_ENQ_URL', plugin_dir_url(__FILE__) );

//Grabbing Settings
$gtsWooCatData = "";
$gtsWooCatData = get_option('woocat_opt');

//Registering Session
function register_session(){
    if( !session_id() )
        session_start();
}
add_action('init','register_session');


//Mode Value : Check and Take
$catalogModeDisable = 0;

if( isset( $gtsWooCatData['disable_catalog'] ) && $gtsWooCatData['disable_catalog'] != "" ){
	$catalogModeDisable = $gtsWooCatData['disable_catalog'];
}

$shopModeWithEnq = 0;

if( isset( $gtsWooCatData['shop_enquiry'] ) && $gtsWooCatData['shop_enquiry'] != "" ){
	$shopModeWithEnq = $gtsWooCatData['shop_enquiry'];
}

//Removing Shopping Functionality by remove action

function gts_remove_woocommerce_loop_btns()
{
	remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
	remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30 );
 
	// Remove add to cart button from the product details page
	remove_action( 'woocommerce_before_add_to_cart_form', 'woocommerce_template_single_product_add_to_cart', 10, 2);
	
	remove_action( 'woo_nav_after', 'wootique_cart_button', 10);
	remove_action( 'woo_nav_after', 'wootique_checkout_button', 20);
 
}

//If Catalog Mode is Not Off. i.e. Catalog Mode 'ON'
if( $catalogModeDisable != 1 ){
	add_action('init','gts_remove_woocommerce_loop_btns');
	add_filter('woocommerce_get_price_html', 'gts_alternate_button_for_quote');
}

//If Shop mode with Enquiry 'ON'
if( $shopModeWithEnq == 1 && $catalogModeDisable == 1 ){
	add_filter('woocommerce_get_price_html', 'gts_alternate_button_for_quote');
}

//General Conditoin, if no options found, then keep button ON


//Applying Filter on Prince HTML

function gts_alternate_button_for_quote( $content )
{
    //Grabbing some user defined options, if set
	//Grabbing Settings
	$gtsWooCatData = get_option('woocat_opt');
	
	//Tag Value
	$priceTagValue = 0;

	if( isset( $gtsWooCatData['hide_price'] ) && $gtsWooCatData['hide_price'] != "" ){
		$priceTagValue = $gtsWooCatData['hide_price'];
	}

	//Button Value
	$buttonEnabled = "on";
	$buttonText = "";
	$buttonRadius = "0";

	if( isset( $gtsWooCatData['custom_btn']['enabled'] ) && $gtsWooCatData['custom_btn']['enabled'] != "" ){
		$buttonEnabled = $gtsWooCatData['custom_btn']['enabled'];
	}

	if( isset( $gtsWooCatData['custom_btn']['btn_text'] ) && $gtsWooCatData['custom_btn']['btn_text'] != "" ){
		$buttonText = $gtsWooCatData['custom_btn']['btn_text'];
	}

	if( isset( $gtsWooCatData['custom_btn']['btn_radius'] ) && $gtsWooCatData['custom_btn']['btn_radius'] != "" ){
		$buttonRadius = $gtsWooCatData['custom_btn']['btn_radius'];
	}
	
	//Button URL Value
	//Button Value
	$urlEnabled = "";
	$urlText = "";
	$urlTarget = 'target="_self"';

	if( isset( $gtsWooCatData['btn_url_check']['enabled'] ) && $gtsWooCatData['btn_url_check']['enabled'] != "" ){
		$urlEnabled = $gtsWooCatData['btn_url_check']['enabled'];
	}

	if( isset( $gtsWooCatData['btn_url_check']['btn_url'] ) && $gtsWooCatData['btn_url_check']['btn_url'] != "" ){
		$urlText = $gtsWooCatData['btn_url_check']['btn_url'];
	}
	
	if( isset( $gtsWooCatData['btn_url_check']['link_new_val'] ) && $gtsWooCatData['btn_url_check']['link_new_val'] == "on" ){
		$urlTarget = 'target="_blank"';
	}
	
	$urlTargetFinal = "";
	$urlFinal = "";
	if( $urlEnabled == "on" ){
		$urlTargetFinal = $urlTarget;
		$urlFinal = $urlText;
	}
	
	
	//Setting Button Text
	$buttonLabelText = "";
	
	if( isset($buttonText) && $buttonText != "" && $buttonText != NULL )
	{
		$buttonLabelText = $buttonText;
	}
	else
	{
		$buttonLabelText = "Add to Quote";
	}
	
	//Preparing Output Block
	$actual_content = "";
	$returnData = "";
	
	if( !isset( $priceTagValue ) || $priceTagValue == 0 ) { 
		$actual_content = $content."<br>"; 
	}
	
	if( $buttonEnabled == "on" ){
		$returnData = $actual_content.'
				 <p class="product-enquiry-button-custom">
					<a data-title="'.get_the_title().'" data-id="'.get_the_ID().'" class="product-enquiry-click click-link-btn product-btn-'.get_the_ID().'" href="'.$urlFinal.'" '.$urlTargetFinal.'>'
						.$buttonLabelText.
					'</a>
				 </p>';
	}
	else{
		$returnData = $actual_content;
	}
				 
	return $returnData;
	

}

//Adding necessary files

require_once('gts-woocommerce-catalog-assets.php');
require_once('admin-page/custom-settings.php');
require_once('gts-woocommerce-catalog-inclusion.php');
require_once('gts-woocommerce-catalog-ajax.php');
require_once('gts-woocommerce-catalog-widget.php');
require_once('gts-woocommerce-catalog-integration.php');
require_once('gts-woocommerce-catalog-enqform.php');
